/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.manager;

import filenet.vw.api.VWException;
import filenet.vw.api.VWQueue;
import filenet.vw.api.VWQueueDefinition;
import filenet.vw.api.VWSession;
import filenet.vw.apps.manager.IVWFolderSelectionListener;
import filenet.vw.apps.manager.IVWMilestonesSelectionListener;
import filenet.vw.apps.manager.IVWQueueSelectionListener;
import filenet.vw.apps.manager.IVWWorkflowManagerActionListener;
import filenet.vw.apps.manager.VWFolderSelectionEvent;
import filenet.vw.apps.manager.VWMilestonesSelectionEvent;
import filenet.vw.apps.manager.VWNodeInformation;
import filenet.vw.apps.manager.VWQueryDefinitionDialog;
import filenet.vw.apps.manager.VWQueueSelectionEvent;
import filenet.vw.apps.manager.VWUserPreferencesDialog;
import filenet.vw.apps.manager.VWWorkflowManagerActionEvent;
import filenet.vw.apps.manager.VWWorkflowManagerFolderPane;
import filenet.vw.apps.manager.VWWorkflowManagerItemPane;
import filenet.vw.apps.manager.VWWorkflowManagerToolBar;
import filenet.vw.apps.manager.resources.VWResource;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWBaseCore;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWSplitPane;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.query.IVWPerformSearchListener;
import filenet.vw.toolkit.utils.query.VWPerformSearchEvent;
import filenet.vw.toolkit.utils.wfdefinition.VWDefaultSessionProxy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Locale;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.event.EventListenerList;

public class VWWorkflowManagerPanel
extends VWBaseCore
implements IVWFolderSelectionListener,
IVWQueueSelectionListener,
IVWMilestonesSelectionListener,
IVWWorkflowManagerActionListener {
    private VWSession m_vwSession = null;
    private VWSessionInfo m_sessionInfo = null;
    private Container m_parentContainer = null;
    private JApplet m_parentApplet = null;
    private Frame m_parentFrame = null;
    private String m_selectedQueueName = null;
    private VWQueryDefinitionDialog m_queryDefinitionDlg = null;
    private boolean m_queueSelectionChanged = true;
    private EventListenerList m_searchListenerList = null;
    private VWUserPreferencesDialog m_userPreferencesDlg = null;
    private Integer m_queueContentsBegin = null;
    private Integer m_queueContentsEnd = null;
    private Integer m_queueCountTotal = null;
    private JLabel m_displayQueueCount = null;
    private VWWorkflowManagerToolBar m_toolBar = null;
    private VWWorkflowManagerFolderPane m_folderPanel = null;
    private VWWorkflowManagerItemPane m_itemPanel = null;
    private Container m_contentPane = null;

    public void init(VWSessionInfo sessionInfo) {
        try {
            this.m_parentContainer = sessionInfo.getParentContainer();
            this.m_parentApplet = sessionInfo.getParentApplet();
            this.m_vwSession = sessionInfo.getSession();
            this.m_sessionInfo = sessionInfo;
            if (this.m_vwSession != null) {
                Locale browserLocale = sessionInfo.getBrowserLocale();
                if (browserLocale != null) {
                    this.m_vwSession.setClientLocale(browserLocale);
                }
                VWDefaultSessionProxy.setSession(this.m_vwSession);
            }
            this.m_searchListenerList = new EventListenerList();
            if (this.m_parentContainer instanceof JApplet) {
                this.m_contentPane = ((JApplet)this.m_parentContainer).getContentPane();
            } else if (this.m_parentContainer instanceof JFrame) {
                this.m_contentPane = ((JFrame)this.m_parentContainer).getContentPane();
            }
            this.m_parentFrame = VWModalDialog.getParentFrameUsingContainer(this.m_parentContainer);
            super.init(sessionInfo);
            this.m_contentPane.setLayout(new BorderLayout());
            this.initApplicationPane(sessionInfo);
            super.performInitialRefresh();
            this.m_folderPanel.addFolderSelectionListener(this);
            this.m_folderPanel.addFolderSelectionListener(this.m_itemPanel);
            this.m_folderPanel.addFolderSelectionListener(this.m_toolBar);
            this.m_folderPanel.addQueueSelectionListener(this);
            this.m_folderPanel.addQueueSelectionListener(this.m_itemPanel);
            this.m_folderPanel.addQueueSelectionListener(this.m_toolBar);
            this.m_folderPanel.addMilestonesSelectionListener(this);
            this.m_folderPanel.addMilestonesSelectionListener(this.m_itemPanel);
            this.m_folderPanel.addMilestonesSelectionListener(this.m_toolBar);
            this.m_folderPanel.addWorkflowManagerActionListener(this);
            this.m_itemPanel.addFolderOpenListener(this.m_folderPanel);
            this.m_itemPanel.addItemSelectionListener(this.m_toolBar);
            this.addPerformSearchListener(this.m_itemPanel);
            this.m_folderPanel.selectRoot();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        if (this.m_parentContainer != null) {
            this.m_parentContainer.invalidate();
            this.m_parentContainer.validate();
            this.m_parentContainer.repaint();
        }
    }

    public void destroy() {
        this.m_toolBar = null;
        this.m_folderPanel = null;
        this.m_itemPanel = null;
        this.m_queryDefinitionDlg = null;
        this.m_userPreferencesDlg = null;
        this.m_vwSession = null;
    }

    public void displayHelp() {
        VWHelp.displayPage(VWHelp.Help_General + "bpfwm009.htm");
    }

    public void displayQueryDialog() {
        try {
            if (this.m_vwSession == null || this.m_selectedQueueName == null) {
                return;
            }
            VWNodeInformation nodeInfo = this.m_folderPanel.getCurrentNodeInformation();
            if (this.m_queueSelectionChanged) {
                this.m_parentContainer.setCursor(Cursor.getPredefinedCursor(3));
                VWQueue vwQueue = this.m_vwSession.getQueue(this.m_selectedQueueName);
                VWQueueDefinition vwQueueDef = vwQueue.fetchQueueDefinition();
                this.m_queryDefinitionDlg = new VWQueryDefinitionDialog(this.m_parentFrame, vwQueueDef, nodeInfo);
                this.m_queueSelectionChanged = false;
                this.m_parentContainer.setCursor(Cursor.getPredefinedCursor(0));
            }
            this.m_queryDefinitionDlg.setVisible(true);
            if (this.m_queryDefinitionDlg.getValue() == 0) {
                VWPerformSearchEvent vwSearchEvent = new VWPerformSearchEvent(this);
                vwSearchEvent.setFilterString(this.m_queryDefinitionDlg.getFilterString());
                this.m_queryDefinitionDlg.getIndexParameters(vwSearchEvent);
                vwSearchEvent.setColumnNames(this.m_queryDefinitionDlg.getSelectedColumns());
                nodeInfo.setSelectedColumns(this.m_queryDefinitionDlg.getSelectedColumns());
                this.fireSearchEvent(vwSearchEvent);
                this.refresh();
            }
            this.m_queryDefinitionDlg.setVisible(false);
        }
        catch (VWException ex) {
            VWDebug.logException(ex);
        }
    }

    public void displayUserInfo() {
        this.m_userPreferencesDlg.setVisible(true);
        this.m_itemPanel.setMaxRowsDisplay(this.m_userPreferencesDlg.getMaxRowsReturn());
    }

    public void openSelectedItem() {
        if (this.m_itemPanel != null) {
            this.m_itemPanel.openSelectedItem();
        }
    }

    public void deleteStatusTracker() {
        if (this.m_itemPanel != null) {
            this.m_itemPanel.deleteSelectedItem();
        }
    }

    public void refresh() {
        if (this.m_folderPanel != null) {
            this.m_folderPanel.refresh();
        }
        if (this.m_itemPanel != null && this.m_toolBar != null) {
            this.m_toolBar.enableNext(this.m_itemPanel.refresh());
        }
        this.m_queueContentsBegin = new Integer(1);
        this.updateQueueCount();
    }

    public void performNext() {
        if (this.m_itemPanel != null) {
            this.m_toolBar.enableNext(this.m_itemPanel.performNext());
        }
        this.m_queueContentsBegin = new Integer(this.m_queueContentsEnd + 1);
        this.updateQueueCount();
    }

    public void selectionChanged(VWFolderSelectionEvent event) {
        this.m_selectedQueueName = null;
        this.m_itemPanel.refresh();
        this.m_displayQueueCount.setText("");
    }

    public void selectionChanged(VWQueueSelectionEvent event) {
        this.m_selectedQueueName = event.getQueueName();
        this.m_queueSelectionChanged = true;
        if (event.getUpdateItemPane()) {
            this.m_itemPanel.refresh();
        }
        this.m_toolBar.enableNext(this.m_itemPanel.getCanPerformNext());
        this.m_queueContentsBegin = new Integer(1);
        this.updateQueueCount();
    }

    public void selectionChanged(VWMilestonesSelectionEvent event) {
        this.m_selectedQueueName = null;
        this.m_queueSelectionChanged = true;
        if (event.getUpdateItemPane()) {
            this.m_itemPanel.refresh();
        }
        this.m_toolBar.enableNext(this.m_itemPanel.getCanPerformNext());
        this.m_queueContentsBegin = new Integer(1);
        this.updateQueueCount();
    }

    public void actionPerformed(VWWorkflowManagerActionEvent event) {
        this.m_parentContainer.setCursor(Cursor.getPredefinedCursor(3));
        switch (event.getType()) {
            case 1: {
                this.openSelectedItem();
                break;
            }
            case 2: {
                this.displayQueryDialog();
                break;
            }
            case 3: {
                this.refresh();
                break;
            }
            case 4: {
                this.displayUserInfo();
                break;
            }
            case 6: {
                this.deleteStatusTracker();
                break;
            }
            case 5: {
                this.displayHelp();
                break;
            }
            case 7: {
                this.performNext();
            }
        }
        this.m_parentContainer.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void addPerformSearchListener(IVWPerformSearchListener psl) {
        this.m_searchListenerList.add(IVWPerformSearchListener.class, psl);
    }

    public void removePerformSearchListener(IVWPerformSearchListener psl) {
        this.m_searchListenerList.remove(IVWPerformSearchListener.class, psl);
    }

    private void fireSearchEvent(VWPerformSearchEvent event) {
        if (event == null) {
            return;
        }
        Object[] listeners = this.m_searchListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IVWPerformSearchListener.class) continue;
            ((IVWPerformSearchListener)listeners[i + 1]).searchCriteriaChanged(event);
        }
    }

    private void updateQueueCount() {
        if (this.m_itemPanel != null && this.m_itemPanel.getHasElements()) {
            int totalItems = this.m_itemPanel.getQueryResultsCount();
            this.m_queueCountTotal = new Integer(totalItems);
            this.m_queueContentsEnd = this.m_itemPanel.getCanPerformNext() ? new Integer(this.m_itemPanel.getMaxRowsDisplay() + this.m_queueContentsBegin - 1) : new Integer(this.m_queueCountTotal);
            this.m_displayQueueCount.setText(VWResource.s_displaying.toString(this.m_queueContentsBegin.toString(), this.m_queueContentsEnd.toString(), this.m_queueCountTotal.toString()));
        } else {
            this.m_displayQueueCount.setText("");
        }
    }

    private void initApplicationPane(VWSessionInfo sessionInfo) {
        this.m_contentPane.setLayout(new GridBagLayout());
        this.m_toolBar = new VWWorkflowManagerToolBar();
        this.m_toolBar.setAlignmentX(0.0f);
        this.m_toolBar.addWorkflowManagerActionListener(this);
        this.m_folderPanel = new VWWorkflowManagerFolderPane(this.m_vwSession);
        this.m_itemPanel = new VWWorkflowManagerItemPane(this.m_vwSession);
        this.m_userPreferencesDlg = new VWUserPreferencesDialog(this.m_parentFrame, sessionInfo);
        this.m_itemPanel.setMaxRowsDisplay(this.m_userPreferencesDlg.getMaxRowsReturn());
        this.m_folderPanel.setParentContainer(this.m_parentContainer);
        this.m_itemPanel.setParentContainer(this.m_parentContainer);
        this.m_itemPanel.setParentApplet(this.m_parentApplet);
        Locale browserLocale = this.m_sessionInfo.getBrowserLocale();
        ComponentOrientation compOrientation = null;
        compOrientation = browserLocale != null ? ComponentOrientation.getOrientation(browserLocale) : ComponentOrientation.getOrientation(Locale.getDefault());
        VWSplitPane splitPane = null;
        if (compOrientation.isLeftToRight()) {
            splitPane = new VWSplitPane(1, this.m_folderPanel, this.m_itemPanel);
            splitPane.setDividerLocation(0.28);
        } else {
            splitPane = new VWSplitPane(1, this.m_itemPanel, this.m_folderPanel);
            splitPane.setDividerLocation(0.7);
        }
        GridBagConstraints gbCons = new GridBagConstraints();
        gbCons.gridx = 0;
        gbCons.gridy = 0;
        gbCons.gridwidth = 1;
        gbCons.gridheight = 1;
        gbCons.weightx = 0.0;
        gbCons.weighty = 0.0;
        gbCons.anchor = 21;
        gbCons.fill = 0;
        gbCons.insets = new Insets(2, 4, 2, 4);
        this.m_contentPane.add((Component)this.m_toolBar, gbCons);
        ++gbCons.gridx;
        gbCons.weightx = 1.0;
        gbCons.anchor = 10;
        gbCons.gridwidth = 0;
        gbCons.fill = 2;
        this.m_displayQueueCount = new JLabel("", 0);
        this.m_contentPane.add((Component)this.m_displayQueueCount, gbCons);
        gbCons.gridx = 0;
        ++gbCons.gridy;
        gbCons.weightx = 2.0;
        gbCons.weighty = 2.0;
        gbCons.gridwidth = 0;
        gbCons.gridheight = 0;
        gbCons.fill = 1;
        this.m_contentPane.add((Component)splitPane, gbCons);
    }
}

